<?php

namespace GuetasClientForJoomla;
defined('_JEXEC') or die('Restricted access');
/**
 * @package GuetasClientForJoomla
 * @version 2.3.10
 * @author Stefan Meier
 * @copyright (C) 2017-2023 Stefan Meier, Guetas Meier
 * @license GNU/GPLv3 see http://www.gnu.org/licenses/gpl-3.0.html or LICENSE.txt
 **/

require('vendor/guetas/guetas-client/GuetasClientBootstrap.php');
require('LoggerForJoomla.php');

use GuetasClient\GuetasClient;

/**
 * Class GuetasClientForJoomla
 * @since 2.0.0
 */
class GuetasClientForJoomla extends GuetasClient
{
    /**
     * @var array $replace_text
     * @since 2.0.0
     */
    protected $replace_text = [
        '{guetas_vouchers}',
        '{guetas_gutscheine}',
    ];

    /**
     * @var array $client_information
     * @since 2.0.0
     */
    protected $client_information = [
        'client_name'    => 'GuetasClientForJoomla',
        'client_version' => '2.3.10',
    ];

    /**
     * @var $article
     * @since 2.0.0
     */
    protected $article;

    /**
     * GuetasClientForJoomla constructor.
     * @param $article
     * @param array $config
     * @since 2.0.0
     */
    public function __construct($article, $config)
    {
        $this->article =& $article;
        parent::__construct($_GET, $_POST, null, $config);
    }

    /**
     * Method setLogger
     * Creates a Logger instance.
     * @since 2.0.0
     */
    public function setLogger()
    {
        $this->logger = new LoggerForJoomla();
    }

    /**
     * Method setLanguageCode
     * Sets the clients language code depending on input parameters.
     * @param string|null $language_code
     * @return bool
     * @since 2.0.0
     */
    public function setLanguageCode(string $language_code = null): bool
    {
        $lang = \JFactory::getLanguage();
        $this->language_code = mb_substr($lang->getTag(), 0, 2);
        return true;
    }

    /**
     * Method generateOutput
     * Generates the output. The GuetasClientForJoomla acts as Joomla content plugin.
     * @since 2.0.0
     */
    public function generateOutput(): string
    {
        foreach ($this->replace_text as $replace_text) {
            $this->article->text = str_replace($replace_text, $this->html, $this->article->text);
        }
        return $this->html;
    }

    /**
     * Method getCssUrl
     * Returns the URL where the CSS file is located.
     * @return string
     * @since 2.0.0
     */
    public function getCssUrl(): string
    {
        return \JURI::base() . 'media/guetas/css/guetas.css';
    }

    /**
     * Method getImagesUrl
     * Returns the URL where image files are located.
     * @return string
     * @since 2.0.0
     */
    public function getImagesUrl(): string
    {
        return \JURI::base() . 'media/guetas/images/';
    }
}
