<?php
namespace GuetasClientForJoomla;
defined('_JEXEC') or die('Restricted access');
/**
 * @package GuetasClientForJoomla
 * @version 2.3.10
 * @author Stefan Meier
 * @copyright (C) 2017-2023 Stefan Meier, Guetas Meier
 * @license GNU/GPLv3 see http://www.gnu.org/licenses/gpl-3.0.html or LICENSE.txt
 **/

/**
 * Class LoggerForJoomla
 * @since 2.0.0
 */
class LoggerForJoomla
{
    /**
     * LoggerForJoomla constructor.
     * @since 2.0.0
     */
    public function __construct()
    {
        \JLog::addLogger(
            array(
                'text_file' => 'guetas.' . date('Y-m-d') . '.log.php'
            ),
            \JLog::ALL,
            ['guetas']
        );
    }

    /**
     * Method logException
     * Logs an exception into the log.
     * @param \Exception $exception
     * @since 2.0.0
     */
    public function logException(\Exception $exception)
    {
        \JLog::add(
            'Exception code(' . $exception->getCode() . '): ' . $exception->getMessage(), \JLog::ERROR, 'guetas'
        );
    }

    /**
     * Method logMessage
     * Logs a string into the log.
     * @param string $message
     * @since 2.0.0
     */
    public function logMessage($message)
    {
        \JLog::add(
            $message, \JLog::INFO, 'guetas'
        );
    }
}
