<?php
defined('_JEXEC') or die('Restricted access');
/**
 * @package GuetasClientForJoomla
 * @version 2.3.10
 * @author Stefan Meier
 * @copyright (C) 2017-2023 Stefan Meier, Guetas Meier
 * @license GNU/GPLv3 see http://www.gnu.org/licenses/gpl-3.0.html or LICENSE.txt
 **/

require('GuetasClientForJoomla.php');

use GuetasClientForJoomla\GuetasClientForJoomla;
use GuetasClientForJoomla\LoggerForJoomla;

class plgContentGuetas extends JPlugin
{
    private static $voucher_bar_was_added = false;

    function onContentPrepare($context, $article, $params, $limitstart)
    {
        $guetas_client = new GuetasClientForJoomla($article,
            [
                'api_id'       => $this->params->get('guetas_api_id'),
                'api_key'      => $this->params->get('guetas_api_key'),
                'private_path' => __DIR__ . '/private/',
                'public_path'  => JPATH_SITE . '/media/guetas/',
                'clear_cache'  => $this->params->get('guetas_clear_cache'),
            ]
        );
        $guetas_client->execute();
        $guetas_client->generateOutput();
        $document = \JFactory::getDocument();
        $document->addStyleSheet($guetas_client->getCssUrl());
        try {
            if (self::$voucher_bar_was_added == false) {
                if ($guetas_client->getVoucherBarIsActive()) {
                    $voucher_bar_text = $guetas_client->getVoucherBarText();
                    $document->addScript('https://static.guetas.com/voucher-bar/voucher-bar.js', 'text/javascript');
                    $document->addScriptDeclaration('guetasVoucherBarCreate(\'' . $voucher_bar_text . '\');');
                }
                self::$voucher_bar_was_added = true;
            }
        } catch (Exception $exception) {
            (new LoggerForJoomla())->logException($exception);
        }
        return true;
    }
}
