<?php
defined('_JEXEC') or die('Restricted access');
/**
 * @package GuetasClient
 * @version 2.3.2
 * @author Stefan Meier
 * @copyright (C) 2017-2023 Stefan Meier, Guetas Meier
 * @license GNU/GPLv3 see http://www.gnu.org/licenses/gpl-3.0.html or LICENSE.txt
 **/
spl_autoload_register_guetas();

function spl_autoload_register_guetas() {
    spl_autoload_register(function ($class_name) {
        if (strpos($class_name, 'GuetasClient\\') !== false) {
            $src_class_name = str_replace('GuetasClient\\', 'src/', $class_name);
            $src_file_name = str_replace('\\', '/', $src_class_name);
            $php_file_name = __DIR__ . '/' . $src_file_name . '.php';
            if (file_exists($php_file_name)) {
                require $php_file_name;
            }
        }
    });
}

function load_guetas_client($config_file_name = null, $config_array = []): \GuetasClient\GuetasClient
{
    if ($config_file_name == null) {
        $config_file_name = dirname(__DIR__) . '/guetas_config.xml';
    }
    return (new GuetasClient\GuetasClient(
        $_GET, $_POST, $config_file_name, $config_array
    ))->execute();
}
