<?php
/**
 * @package GuetasClient
 * @version 2.3.10
 * @author Stefan Meier
 * @copyright (C) 2017-2023 Stefan Meier, Guetas Meier
 * @license GNU/GPLv3 see http://www.gnu.org/licenses/gpl-3.0.html or LICENSE.txt
 **/

namespace GuetasClient\File\Config;
defined('_JEXEC') or die('Restricted access');

use GuetasClient\Exception\GuetasClientException;

class ClearCacheTimestampFile extends ConfigFile
{
    protected $file_type = 'timestamp';

    public function __construct()
    {
        parent::__construct('timestamp.cfg');
    }

    /**
     * Method newTimestamp
     * Saves the current unix timestamp to the file.
     * @throws GuetasClientException
     */
    public function newTimestamp()
    {
        $this->saveData(time());
    }

    /**
     * Method findOrCreate
     * Searches the requested file on the file system and creates it if not available yet.
     * @return static
     * @throws GuetasClientException
     */
    public static function findOrCreate(): ClearCacheTimestampFile
    {
        $file = new static();
        if (!$file->exists()) {
            $file->saveData(0);
        }
        return $file;
    }
}
