<?php
/**
 * @package GuetasClient
 * @version 2.3.10
 * @author Stefan Meier
 * @copyright (C) 2017-2023 Stefan Meier, Guetas Meier
 * @license GNU/GPLv3 see http://www.gnu.org/licenses/gpl-3.0.html or LICENSE.txt
 **/

namespace GuetasClient\File\Config;
defined('_JEXEC') or die('Restricted access');

use GuetasClient\Exception\GuetasClientException;
use GuetasClient\File\BasicFile;

class ConfigFile extends BasicFile
{
    protected $path_type = 'private';
    protected $sub_folder = 'config/';

    /**
     * Method deleteAll
     * Deletes all files of the same type as the file (including itself).
     * @return true
     * @throws GuetasClientException
     */
    public function deleteAll(): bool
    {
        throw new GuetasClientException("Method deleteAll not defined for ConfigFile file types.");
    }
}
