<?php
/**
 * @package GuetasClient
 * @version 2.3.10
 * @author Stefan Meier
 * @copyright (C) 2017-2023 Stefan Meier, Guetas Meier
 * @license GNU/GPLv3 see http://www.gnu.org/licenses/gpl-3.0.html or LICENSE.txt
 **/

namespace GuetasClient;
defined('_JEXEC') or die('Restricted access');

class VoucherController
{
    /** @var string $server_url */
    protected $server_url;
    /** @var string $server_url */
    protected $backup_server_url;
    /** @var string $api_id */
    protected $api_id;
    /** @var string $api_key */
    protected $api_key;

    /**
     * VoucherController constructor.
     * Constructs the voucher controller.
     * @param string $server_url
     * @param string $api_id
     * @param string $api_key
     */
    public function __construct(string $server_url, string $backup_server_url, string $api_id, string $api_key)
    {
        $this->server_url = $server_url;
        $this->backup_server_url = $backup_server_url;
        $this->api_id = $api_id;
        $this->api_key = $api_key;
    }

    /**
     * Method listVouchers
     * Prepares all required resources and HTML to display a page listing vouchers.
     * @param string $scope
     * @param string $language
     * @return string
     * @throws Exception\GuetasClientException
     * @throws Exception\GuetasValidationFailedException
     */
    public function listVouchers(string $scope, string $language): string
    {
        $res_mgr = new ResourceManager($this->server_url, $this->backup_server_url, $this->api_id, $this->api_key);
        $res_mgr->prepareResources('list', $scope, $language);
        return $res_mgr->getHtml();
    }
}
